<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// جلب المشاريع لاختيار المشروع
$projects = $pdo->query('SELECT id, name FROM projects ORDER BY id DESC')->fetchAll();

// رفع ملف جديد
if (isset($_POST['upload_media'])) {
    $project_id = intval($_POST['project_id']);
    $type = $_POST['type'];
    if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $allowed_img = ['jpg','jpeg','png','gif'];
        $allowed_vid = ['mp4','webm','avi'];
        $ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
        $target_dir = '../uploads/';
        $filename = uniqid().'.'.$ext;
        $target_file = $target_dir . $filename;
        if (($type == 'image' && in_array($ext, $allowed_img)) || ($type == 'video' && in_array($ext, $allowed_vid))) {
            if (move_uploaded_file($_FILES['file']['tmp_name'], $target_file)) {
                $stmt = $pdo->prepare('INSERT INTO media (project_id, type, file_path) VALUES (?, ?, ?)');
                $stmt->execute([$project_id, $type, $filename]);
            }
        }
    }
}

// حذف ملف
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare('SELECT file_path FROM media WHERE id = ?');
    $stmt->execute([$id]);
    $file = $stmt->fetchColumn();
    if ($file && file_exists('../uploads/'.$file)) {
        unlink('../uploads/'.$file);
    }
    $stmt = $pdo->prepare('DELETE FROM media WHERE id = ?');
    $stmt->execute([$id]);
}

// جلب جميع الملفات
$media = $pdo->query('SELECT m.*, p.name as project_name FROM media m LEFT JOIN projects p ON m.project_id = p.id ORDER BY m.id DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الصور والفيديوهات</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 1100px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 32px; }
        th, td { padding: 10px; border-bottom: 1px solid #EEEEEE; text-align: center; }
        th { background: #EA9218; color: #fff; }
        .btn { padding: 6px 16px; border-radius: 4px; border: none; cursor: pointer; }
        .btn-delete { background: #d00; color: #fff; }
        .form-inline input, .form-inline select { margin: 0 8px 8px 0; padding: 6px; }
        .form-inline { display: flex; flex-wrap: wrap; align-items: center; gap: 8px; margin-bottom: 24px; }
        .media-thumb { max-width: 120px; max-height: 80px; border-radius: 6px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>إدارة الصور والفيديوهات</h2>
        <!-- نموذج رفع ملف جديد -->
        <form class="form-inline" method="post" enctype="multipart/form-data">
            <select name="project_id" required>
                <option value="">اختر المشروع</option>
                <?php foreach ($projects as $project): ?>
                    <option value="<?= $project['id'] ?>"> <?= htmlspecialchars($project['name']) ?> </option>
                <?php endforeach; ?>
            </select>
            <select name="type" required>
                <option value="image">صورة</option>
                <option value="video">فيديو</option>
            </select>
            <input type="file" name="file" required>
            <button class="btn" type="submit" name="upload_media">رفع الملف</button>
        </form>
        <!-- جدول الملفات -->
        <table>
            <tr>
                <th>الرقم</th>
                <th>اسم المشروع</th>
                <th>النوع</th>
                <th>المعاينة</th>
                <th>حذف</th>
            </tr>
            <?php foreach ($media as $m): ?>
            <tr>
                <td><?= $m['id'] ?></td>
                <td><?= htmlspecialchars($m['project_name']) ?></td>
                <td><?= $m['type']=='image'?'صورة':'فيديو' ?></td>
                <td>
                    <?php if ($m['type']=='image'): ?>
                        <img src="../uploads/<?= htmlspecialchars($m['file_path']) ?>" class="media-thumb" alt="صورة المشروع">
                    <?php else: ?>
                        <video src="../uploads/<?= htmlspecialchars($m['file_path']) ?>" class="media-thumb" controls></video>
                    <?php endif; ?>
                </td>
                <td>
                    <a class="btn btn-delete" href="?delete=<?= $m['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف الملف؟');">حذف</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
